import { VNode } from 'vue';
declare const CCarousel: import("vue").DefineComponent<{
    /**
     * Adding in the previous and next controls.
     */
    controls: BooleanConstructor;
    /**
     * Add darker controls, indicators, and captions.
     */
    dark: BooleanConstructor;
    /**
     * index of the active item.
     */
    index: {
        type: NumberConstructor;
        default: number;
        required: false;
    };
    /**
     * Adding indicators at the bottom of the carousel for each item.
     */
    indicators: BooleanConstructor;
    /**
     * The amount of time to delay between automatically cycling an item. If false, carousel will not automatically cycle.
     */
    interval: {
        type: (NumberConstructor | BooleanConstructor)[];
        default: number;
        required: false;
    };
    /**
     * If set to 'hover', pauses the cycling of the carousel on mouseenter and resumes the cycling of the carousel on mouseleave. If set to false, hovering over the carousel won't pause it.
     */
    pause: {
        type: (StringConstructor | BooleanConstructor)[];
        default: string;
        required: false;
        validator: (value: boolean | string) => boolean;
    };
    /**
     * Set type of the transition.
     *
     * @values 'crossfade', 'slide'
     */
    transition: {
        type: StringConstructor;
        default: string;
        required: false;
        validator: (value: string) => boolean;
    };
    /**
     * Set whether the carousel should cycle continuously or have hard stops.
     */
    wrap: {
        type: BooleanConstructor;
        default: boolean;
        required: false;
    };
}, () => VNode<import("vue").RendererNode, import("vue").RendererElement, {
    [key: string]: any;
}>, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<import("vue").ExtractPropTypes<{
    /**
     * Adding in the previous and next controls.
     */
    controls: BooleanConstructor;
    /**
     * Add darker controls, indicators, and captions.
     */
    dark: BooleanConstructor;
    /**
     * index of the active item.
     */
    index: {
        type: NumberConstructor;
        default: number;
        required: false;
    };
    /**
     * Adding indicators at the bottom of the carousel for each item.
     */
    indicators: BooleanConstructor;
    /**
     * The amount of time to delay between automatically cycling an item. If false, carousel will not automatically cycle.
     */
    interval: {
        type: (NumberConstructor | BooleanConstructor)[];
        default: number;
        required: false;
    };
    /**
     * If set to 'hover', pauses the cycling of the carousel on mouseenter and resumes the cycling of the carousel on mouseleave. If set to false, hovering over the carousel won't pause it.
     */
    pause: {
        type: (StringConstructor | BooleanConstructor)[];
        default: string;
        required: false;
        validator: (value: boolean | string) => boolean;
    };
    /**
     * Set type of the transition.
     *
     * @values 'crossfade', 'slide'
     */
    transition: {
        type: StringConstructor;
        default: string;
        required: false;
        validator: (value: string) => boolean;
    };
    /**
     * Set whether the carousel should cycle continuously or have hard stops.
     */
    wrap: {
        type: BooleanConstructor;
        default: boolean;
        required: false;
    };
}>>, {
    transition: string;
    pause: string | boolean;
    dark: boolean;
    controls: boolean;
    index: number;
    indicators: boolean;
    interval: number | boolean;
    wrap: boolean;
}>;
export { CCarousel };
