<?php

namespace Plugin\Refund\Http\ApiResource;

use Illuminate\Http\Resources\Json\ResourceCollection;

class RefundReasonCollection extends ResourceCollection
{
    public function toArray($request)
    {
        return [
            'data' => $this->collection->map(function ($data) {
                return [
                    'id' => $data->id,
                    'name' => $data->translation('name', session()->get('api_locale'))
                ];
            })
        ];
    }

    public function with($request)
    {
        return [
            'success' => true,
            'status' => 200
        ];
    }
}
