import { PropType } from 'vue';
type Option = {
    disabled?: boolean;
    label?: string;
    selected?: boolean;
    value?: string;
};
declare const CFormSelect: import("vue").DefineComponent<{
    /**
     * Provide valuable, actionable feedback.
     *
     * @since 4.3.0
     */
    feedback: {
        type: StringConstructor;
    };
    /**
     * Provide valuable, actionable feedback.
     *
     * @since 4.3.0
     */
    feedbackInvalid: {
        type: StringConstructor;
    };
    /**
     * Provide valuable, actionable invalid feedback when using standard HTML form validation which applied two CSS pseudo-classes, `:invalid` and `:valid`.
     *
     * @since 4.3.0
     */
    feedbackValid: {
        type: StringConstructor;
    };
    /**
     * Provide valuable, actionable valid feedback when using standard HTML form validation which applied two CSS pseudo-classes, `:invalid` and `:valid`.
     *
     * @since 4.3.0
     */
    floatingLabel: {
        type: StringConstructor;
    };
    /**
     * Specifies the number of visible options in a drop-down list.
     */
    htmlSize: {
        type: NumberConstructor;
        default: undefined;
        required: false;
    };
    /**
     * The id global attribute defines an identifier (ID) that must be unique in the whole document.
     */
    id: {
        type: StringConstructor;
    };
    /**
     * Set component validation state to invalid.
     */
    invalid: BooleanConstructor;
    /**
     * Add a caption for a component.
     *
     * @since 4.3.0
     */
    label: {
        type: StringConstructor;
    };
    /**
     * The default name for a value passed using v-model.
     */
    modelValue: {
        type: PropType<string | string[]>;
        default: undefined;
        require: boolean;
    };
    multiple: {
        type: BooleanConstructor;
        required: false;
    };
    /**
     * Options list of the select component. Available keys: `label`, `value`, `disabled`.
     * Examples:
     * - `:options="[{ value: 'js', label: 'JavaScript' }, { value: 'html', label: 'HTML', disabled: true }]"`
     * - `:options="['js', 'html']"`
     */
    options: {
        type: PropType<string[] | Option[]>;
        default: undefined;
        required: false;
    };
    /**
     * Size the component small or large.
     *
     * @values 'sm' | 'lg'
     */
    size: {
        type: StringConstructor;
        default: undefined;
        require: boolean;
        validator: (value: string) => boolean;
    };
    /**
     * Add helper text to the component.
     *
     * @since 4.3.0
     */
    text: {
        type: StringConstructor;
    };
    /**
     * Display validation feedback in a styled tooltip.
     *
     * @since 4.3.0
     */
    tooltipFeedback: BooleanConstructor;
    /**
     * Set component validation state to valid.
     */
    valid: BooleanConstructor;
}, () => import("vue").VNode<import("vue").RendererNode, import("vue").RendererElement, {
    [key: string]: any;
}>, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, ("change" | "update:modelValue")[], "change" | "update:modelValue", import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<import("vue").ExtractPropTypes<{
    /**
     * Provide valuable, actionable feedback.
     *
     * @since 4.3.0
     */
    feedback: {
        type: StringConstructor;
    };
    /**
     * Provide valuable, actionable feedback.
     *
     * @since 4.3.0
     */
    feedbackInvalid: {
        type: StringConstructor;
    };
    /**
     * Provide valuable, actionable invalid feedback when using standard HTML form validation which applied two CSS pseudo-classes, `:invalid` and `:valid`.
     *
     * @since 4.3.0
     */
    feedbackValid: {
        type: StringConstructor;
    };
    /**
     * Provide valuable, actionable valid feedback when using standard HTML form validation which applied two CSS pseudo-classes, `:invalid` and `:valid`.
     *
     * @since 4.3.0
     */
    floatingLabel: {
        type: StringConstructor;
    };
    /**
     * Specifies the number of visible options in a drop-down list.
     */
    htmlSize: {
        type: NumberConstructor;
        default: undefined;
        required: false;
    };
    /**
     * The id global attribute defines an identifier (ID) that must be unique in the whole document.
     */
    id: {
        type: StringConstructor;
    };
    /**
     * Set component validation state to invalid.
     */
    invalid: BooleanConstructor;
    /**
     * Add a caption for a component.
     *
     * @since 4.3.0
     */
    label: {
        type: StringConstructor;
    };
    /**
     * The default name for a value passed using v-model.
     */
    modelValue: {
        type: PropType<string | string[]>;
        default: undefined;
        require: boolean;
    };
    multiple: {
        type: BooleanConstructor;
        required: false;
    };
    /**
     * Options list of the select component. Available keys: `label`, `value`, `disabled`.
     * Examples:
     * - `:options="[{ value: 'js', label: 'JavaScript' }, { value: 'html', label: 'HTML', disabled: true }]"`
     * - `:options="['js', 'html']"`
     */
    options: {
        type: PropType<string[] | Option[]>;
        default: undefined;
        required: false;
    };
    /**
     * Size the component small or large.
     *
     * @values 'sm' | 'lg'
     */
    size: {
        type: StringConstructor;
        default: undefined;
        require: boolean;
        validator: (value: string) => boolean;
    };
    /**
     * Add helper text to the component.
     *
     * @since 4.3.0
     */
    text: {
        type: StringConstructor;
    };
    /**
     * Display validation feedback in a styled tooltip.
     *
     * @since 4.3.0
     */
    tooltipFeedback: BooleanConstructor;
    /**
     * Set component validation state to valid.
     */
    valid: BooleanConstructor;
}>> & {
    onChange?: ((...args: any[]) => any) | undefined;
    "onUpdate:modelValue"?: ((...args: any[]) => any) | undefined;
}, {
    invalid: boolean;
    size: string;
    valid: boolean;
    tooltipFeedback: boolean;
    modelValue: string | string[];
    htmlSize: number;
    multiple: boolean;
    options: string[] | Option[];
}>;
export { CFormSelect };
