import { RendererElement } from 'vue';
declare const CModal: import("vue").DefineComponent<{
    /**
     * Align the modal in the center or top of the screen.
     *
     * @values 'top', 'center'
     */
    alignment: {
        default: string;
        validator: (value: string) => boolean;
    };
    /**
     * Apply a backdrop on body while offcanvas is open.
     *
     * @values boolean | 'static'
     */
    backdrop: {
        type: (StringConstructor | BooleanConstructor)[];
        default: boolean;
        validator: (value: boolean | string) => boolean;
    };
    /**
     * A string of all className you want applied to the modal content component.
     */
    contentClassName: {
        type: StringConstructor;
        default: undefined;
    };
    /**
     * Set modal to covers the entire user viewport
     *
     * @values boolean, 'sm', 'md', 'lg', 'xl', 'xxl'
     */
    fullscreen: {
        type: (StringConstructor | BooleanConstructor)[];
        default: undefined;
        validator: (value: boolean | string) => boolean;
    };
    /**
     * Closes the modal when escape key is pressed.
     */
    keyboard: {
        type: BooleanConstructor;
        default: boolean;
    };
    /**
     * Create a scrollable modal that allows scrolling the modal body.
     */
    scrollable: {
        type: BooleanConstructor;
    };
    /**
     * Size the component small, large, or extra large.
     *
     * @values 'sm', 'lg', 'xl'
     */
    size: {
        type: StringConstructor;
        default: undefined;
        validator: (value: string) => boolean;
    };
    /**
     * Remove animation to create modal that simply appear rather than fade in to view.
     */
    transition: {
        type: BooleanConstructor;
        default: boolean;
    };
    /**
     * By default the component is unmounted after close animation, if you want to keep the component mounted set this property to false.
     */
    unmountOnClose: {
        type: BooleanConstructor;
        default: boolean;
    };
    /**
     * Toggle the visibility of alert component.
     */
    visible: BooleanConstructor;
}, () => (false | "" | import("vue").VNode<import("vue").RendererNode, RendererElement, {
    [key: string]: any;
}>)[], unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, ("close" | "show" | "close-prevented")[], "close" | "show" | "close-prevented", import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<import("vue").ExtractPropTypes<{
    /**
     * Align the modal in the center or top of the screen.
     *
     * @values 'top', 'center'
     */
    alignment: {
        default: string;
        validator: (value: string) => boolean;
    };
    /**
     * Apply a backdrop on body while offcanvas is open.
     *
     * @values boolean | 'static'
     */
    backdrop: {
        type: (StringConstructor | BooleanConstructor)[];
        default: boolean;
        validator: (value: boolean | string) => boolean;
    };
    /**
     * A string of all className you want applied to the modal content component.
     */
    contentClassName: {
        type: StringConstructor;
        default: undefined;
    };
    /**
     * Set modal to covers the entire user viewport
     *
     * @values boolean, 'sm', 'md', 'lg', 'xl', 'xxl'
     */
    fullscreen: {
        type: (StringConstructor | BooleanConstructor)[];
        default: undefined;
        validator: (value: boolean | string) => boolean;
    };
    /**
     * Closes the modal when escape key is pressed.
     */
    keyboard: {
        type: BooleanConstructor;
        default: boolean;
    };
    /**
     * Create a scrollable modal that allows scrolling the modal body.
     */
    scrollable: {
        type: BooleanConstructor;
    };
    /**
     * Size the component small, large, or extra large.
     *
     * @values 'sm', 'lg', 'xl'
     */
    size: {
        type: StringConstructor;
        default: undefined;
        validator: (value: string) => boolean;
    };
    /**
     * Remove animation to create modal that simply appear rather than fade in to view.
     */
    transition: {
        type: BooleanConstructor;
        default: boolean;
    };
    /**
     * By default the component is unmounted after close animation, if you want to keep the component mounted set this property to false.
     */
    unmountOnClose: {
        type: BooleanConstructor;
        default: boolean;
    };
    /**
     * Toggle the visibility of alert component.
     */
    visible: BooleanConstructor;
}>> & {
    onShow?: ((...args: any[]) => any) | undefined;
    onClose?: ((...args: any[]) => any) | undefined;
    "onClose-prevented"?: ((...args: any[]) => any) | undefined;
}, {
    transition: boolean;
    visible: boolean;
    size: string;
    alignment: string;
    backdrop: string | boolean;
    contentClassName: string;
    fullscreen: string | boolean;
    keyboard: boolean;
    scrollable: boolean;
    unmountOnClose: boolean;
}>;
export { CModal };
