var sut = require('../../lib/indent').js;
var expect = require('chai').expect;
var ts = '  ';

describe('umd', function () {
  it('umd declaration', function () {
    var expected = `
(function(mod) {
  'use strict';
  if (typeof exports === 'object' && typeof module === 'object') // CommonJS
    mod(require('../../lib/codemirror'));
  else if (typeof define === 'function' && define.amd) // AMD
    define(['../../lib/codemirror'], mod);
  else // Plain browser env
    mod(CodeMirror);
})(function(CodeMirror) {
});
`;
    expect(sut(expected, {tabString: ts})).to.equal(
      expected.replace(/\r*\n/g, '\r\n'));
  });
});
